#!/bin/bash
set +x

# *************************************************************************** #
# File Name: inspect_expand.sh
# Description: ѲĿеչ.
# Input:
# Output:
# Author:
# Created:
# Function List
# History
# 1.Date:
#   Author:
#   Modification:
# **************************************************************************** #

dos2unix $G_SCRIPT_PATH/inspect_lib.sh > /dev/null 2>&1
dos2unix $G_SCRIPT_PATH/inspect_map.sh > /dev/null 2>&1

. $G_SCRIPT_PATH/inspect_lib.sh
. $G_SCRIPT_PATH/inspect_map.sh

G_TMP_FILE="$G_SCRIPT_PATH/tmpfile"
G_REMOTE_TMP_FILE="/tmp/tmpfile"

VALID_IP_FILE="/tmp/tmp_valid_ip"

IP_ROLE_FILE="/tmp/tmp_ip_role"

G_MML_FILE_PATH="/opt/huawei/snas/script/inspect_mml"

EXPAND_CONFIG_FILE="$G_SCRIPT_PATH/expand_config.conf"
PACKAGE_VERSION_FILE="/opt/huawei/deploy/package/version"
LOG_FILE="/var/log/inspect.log"

RepeatTimes=(1 2 3)

G_SEPARATOR="#############################################################################"


function LOG
{
    echo [`date`][$!]$@ >> $LOG_FILE
}
##############################################################################
#500. ڴչѲ

function getItemArrayIndex()
{
    rec=$1

    local index=0

    for item in ${checkItemArray[@]}
    do
        if [ "$rec" = "$item" ]; then
            break
        else
            index=$((index+1))
        fi
    done

    return $index
}

function isExpandSupported()
{
    local checkItem=$1
    local taskid=""

    #ûѲ͹ǰñļѲѲ͹ܺ󣬽Ѳ汾(item 500)
    if [ "${checkItem}" = "500" ]; then
        return 0
    fi
    taskid=$(cat $G_SCRIPT_PATH/inspect_expand.sh | grep "\s*${checkItem})\s*" | tr -d '[:blank:])')
    if [ "$taskid" != "$checkItem" ]; then
        return 1
    fi

    #չѲİ汾ļǷִ֧Ѳ
    productVersionInfo=`cat $PACKAGE_VERSION_FILE | grep "ProductVersion="`
    productVersionValue=$(echo $productVersionInfo | awk -F '=' '{printf $2}')

    checkItemInfo=`cat $EXPAND_CONFIG_FILE | grep -oE "ProductVer[ 0-9]+"`
    if [ "$checkItemInfo" = "" ]; then
        LOG "[$FUNCNAME][$LINENO]file $EXPAND_CONFIG_FILE error!"
        return 1
    fi

    checkItemArray=($checkItemInfo)
    getItemArrayIndex $checkItem
    itemIndex=$?

    checkItemValueInfo=`cat $EXPAND_CONFIG_FILE | grep -oE "^$productVersionValue[ 0-9]+"`
    if [ "$checkItemValueInfo" = "" ]; then
        LOG "[$FUNCNAME][$LINENO]not support $productVersionValue in $EXPAND_CONFIG_FILE"
        return 1
    fi

    checkItemValueArray=($checkItemValueInfo)
    if [ "1" != "${checkItemValueArray[$itemIndex]}" ]; then
        LOG "[$FUNCNAME][$LINENO]checkId($checkItem) is not supported in $EXPAND_CONFIG_FILE,$productVersionValue"
        return 1
    fi

    LOG "[$FUNCNAME][$LINENO]checkId($checkItem) is supported in $EXPAND_CONFIG_FILE,$productVersionValue"

    return 0
}

#ӶѲȥ˺ֻ֤׮
checkFanStatus_MML()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local Result=""
    Result="checkFanStatus_MML is supported expand"
    if [ "$Result" != "" ];then
        WRITE_XML_COMMON 0 "${Result}"
    fi
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

#If source file is same as target file return 0, if source file is not exist retrun 1 orelse return 2
function testDiff()
{
    local srcFile=$1
    local tarFile=$2
    if [ ! -f "${srcFile}" ]; then
        LOG "[$FUNCNAME][$LINENO] Wrong source file ${srcFile}"
        return 1
    fi
    if [ ! -f "${tarFile}" ]; then
        LOG "[$FUNCNAME][$LINENO] Wrong target file ${tarFile}."
        return 2
    fi
    local srcFileSha256=$(sha256sum "${srcFile}" | awk '{print $1}')
    local tarFileSha256=$(sha256sum "${tarFile}" | awk '{print $1}')
    if [ "is${srcFileSha256}" = "is${tarFileSha256}" ]; then
        LOG "[$FUNCNAME][$LINENO] Source file ${srcFile} is same as target file ${tarFile}."
        return 0
    else
        LOG "[$FUNCNAME][$LINENO] Source file ${srcFile} is diff with target file ${tarFile}."
        return 2
    fi
}

#Called by updateInspectEntry only. No need update if returned 0
function isNeedUpdateInspectEntry()
{
    local srcFile=$1
    local iRet=0
    local tmpDir="/tmp/inspectUpd$$"
    if [ ! -d "${tmpDir}" ]; then
        mkdir -p "${tmpDir}"
    fi
    tar -zxf "${srcFile}" -C "${tmpDir}"
    local file=""
    for file in $(ls "${tmpDir}")
    do
        testDiff "${tmpDir}/${file}" /opt/inspect/${file}
        iRet=$?
        if [ ${iRet} -gt 1 ]; then
            rm -rf "${tmpDir}"
            return 1
        fi
    done

    rm -rf "${tmpDir}"
    return 0
}

#Called by updateCollect only. No need update if returned 0
function isNeedUpdateCollect()
{
    local srcFile=$1
    local iRet=0
    local tmpDir="/tmp/inspectUpd$$"
    if [ ! -d "${tmpDir}" ]; then
        mkdir -p "${tmpDir}"
    fi
    tar -zxf "${srcFile}" -C "${tmpDir}"
    local file=""
    for file in $(ls "${tmpDir}")
    do
        testDiff "${tmpDir}/${file}" /opt/huawei/snas/bin/${file}
        iRet=$?
        if [ ${iRet} -gt 1 ]; then
            rm -rf "${tmpDir}"
            return 1
        fi
    done

    rm -rf "${tmpDir}"
    return 0
}

#Called by updateInspect(scripts in /opt/inspect) only. No need update if returned 0
function isNeedUpdateInspect()
{
    local srcFile=$1
    local iRet=0
    local tmpDir="/tmp/inspectUpd$$"
    if [ ! -d "${tmpDir}" ]; then
        mkdir -p "${tmpDir}"
    fi
    tar -zxf "${srcFile}" -C "${tmpDir}"
    local file=""
    for file in $(ls "${tmpDir}")
    do
        testDiff "${tmpDir}/${file}" /opt/inspect/${file}
        iRet=$?
        if [ ${iRet} -gt 1 ]; then
            rm -rf "${tmpDir}"
            return 1
        fi
    done

    rm -rf "${tmpDir}"
    return 0
}

#Called by updateInspectMml only. No need update if returned 0
function isNeedUpdateInspectMml()
{
    local srcFile=$1
    local iRet=0
    local tmpDir="/tmp/inspectUpd$$"
    if [ ! -d "${tmpDir}" ]; then
        mkdir -p "${tmpDir}"
    fi
    tar -zxf "${srcFile}" -C "${tmpDir}"
    local file=""
    for file in $(ls "${tmpDir}")
    do
        testDiff "${tmpDir}/${file}" /opt/huawei/snas/script/inspect_mml/${file}
        iRet=$?
        if [ ${iRet} -gt 1 ]; then
            rm -rf "${tmpDir}"
            return 1
        fi
    done

    rm -rf "${tmpDir}"
    return 0
}

function remote_exec_checkfini
{
    local remote_ip=$1
    local le_pid="$2"
    local err_info=$3

    for time in ${RepeatTimes[*]}; do
        local proresult=`/opt/huawei/deploy/script/localexec.py progress $remote_ip $le_pid`
        local iRet=$?
        if [ $iRet -eq 101 ]; then
            LOG "[${FUNCNAME}]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},Return:$iRet,TryTimes:$time"
            sleep 10
        else
            break
        fi
    done
    local process=`echo $proresult | awk '{print $1}'`
    local errno=`echo $proresult | awk '{print $4}'`

    if [[ $iRet -eq 0 && "$process" != "100" && "$process" != "" ]];then
        return 0    #ѯִгɹԶû
    elif [ $iRet -ne 0 ];then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.iRet($iRet)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:Failed to get command result."
        if [ $iRet -eq 106 ];then
            return 125 # timeout=125
        fi
        return 1    #ѯִʧ
    elif [ $iRet -eq 0 ] && [ "$process" = "100" ] && [ "$errno" = "0" ] ;then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) success.iRet($iRet),errno($errno),process($process)"
        return 2    #ɹɣ˴Ҫ0Ϊɹ
    elif [ "$errno" != "0" ] && [ "$errno" != "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.iRet($iRet) errno($errno)"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        if [ "$errno" = "106" ]; then
            return 125 # timeout=125
        fi
        return 3    #Զִʧ
    elif [ "$process" = "" ] && [ "$errno" = "" ];then
        LOG "[$FUNCNAME]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) failed.process(null), ip not accessed"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 5    #ʱ
    elif [ "$process" = "" ] || [ "$errno" = "" ];then
        LOG "[$FUNCNAME] IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid},exec(get progress) failed.process(null)"
        return 0    #ݴ
    else
        LOG "[$FUNCNAME]IP:$remote_ip,item:${G_CHECK_IDLIST},le_pid:${le_pid}, exec(get progress) failed. Undefined error info"
        WRITE_XML_ERROR 0 "Node:$remote_ip||INFO:$err_info."
        return 4    #δ
    fi
}

function updateToolkit()
{
    local isForce=$1
    local tarFile=""
    local updFileList=""
    local filesInTar=""
    local rmtCmd=""
    local productVersion=""
    local tmpUpdFileList=""
    local defaultPwdCfg="/opt/huawei/snas/script/inspect_mml/default_passwd.ini"

    [ -f /opt/huawei/deploy/package/version ] &&
        productVersion=$(grep ProductVersion /opt/huawei/deploy/package/version | awk -F= '{print $2}')
    rmtCmd="tar zxf /var/log/pkg_inspect_${productVersion}.tar.gz -C /var/log/"
    cd "${TMP_G_SCRIPT_PATH}"
    if [ -f "snas-inspect_${productVersion}.tar.gz" ]; then
        if [ "${isForce}" == "1" ]; then
            tarFile="snas-inspect_${productVersion}.tar.gz"
        else
            isNeedUpdateInspect "${TMP_G_SCRIPT_PATH}/snas-inspect_${productVersion}.tar.gz"
            if [ $? -eq 0 ]; then
                tarFile=""
            else
                tarFile="snas-inspect_${productVersion}.tar.gz"
            fi
        fi
        if [ "${tarFile}" != "" ]; then
            updFileList="${tarFile}"
            filesInTar=$(tar ztf "${tarFile}" | awk '{printf " /opt/inspect/"$0}')
            rmtCmd="${rmtCmd};tar -zxf /var/log/snas-inspect_${productVersion}.tar.gz -C /opt/inspect;\
                              chmod 550 ${filesInTar};chown root:root ${filesInTar}"
        fi
    fi
    if [ -f "snas-inspect_mml_${productVersion}.tar.gz" ]; then
        if [ "${isForce}" == "1" ]; then
            tarFile="snas-inspect_mml_${productVersion}.tar.gz"
        else
            isNeedUpdateInspectMml "${TMP_G_SCRIPT_PATH}/snas-inspect_mml_${productVersion}.tar.gz"
            if [ $? -eq 0 ]; then
                tarFile=""
            else
                tarFile="snas-inspect_mml_${productVersion}.tar.gz"
            fi
        fi
        if [ "${tarFile}" != "" ]; then
            updFileList="${updFileList} ${tarFile}"
            filesInTar=$(tar ztf "${tarFile}" | awk '{printf " /opt/huawei/snas/script/inspect_mml/"$0}')
            rmtCmd="${rmtCmd};tar -zxf /var/log/snas-inspect_mml_${productVersion}.tar.gz -C /opt/huawei/snas/script/inspect_mml/;\
                              chmod 550 ${filesInTar};chown root:group9000 ${filesInTar}"
        fi
        if [ -f ${defaultPwdCfg} ]; then
            rmtCmd="${rmtCmd};chmod 440 ${defaultPwdCfg};chown root:omgroup ${defaultPwdCfg}"
        fi
    fi
    if [ -f "snas-inspect_main_${productVersion}.tar.gz" ]; then
        if [ "${isForce}" == "1" ]; then
            tarFile="snas-inspect_main_${productVersion}.tar.gz"
        else
            isNeedUpdateInspectEntry "${TMP_G_SCRIPT_PATH}/snas-inspect_main_${productVersion}.tar.gz"
            if [ $? -eq 0 ]; then
                tarFile=""
            else
                tarFile="snas-inspect_main_${productVersion}.tar.gz"
            fi
        fi
        if [ "${tarFile}" != "" ]; then
            updFileList="${updFileList} ${tarFile}"
            filesInTar=$(tar ztf "${tarFile}" | awk '{printf " /opt/inspect/"$0}')
            rmtCmd="${rmtCmd};/opt/huawei/snas/script/inspect_mml/CheckItems del /opt/inspect/inspect_entry.sh;\
                              tar -zxf /var/log/snas-inspect_main_${productVersion}.tar.gz -C /opt/inspect;\
                              chmod 550 ${filesInTar};chown root:root ${filesInTar}"
        fi
    fi
    if [ -f "snas-collect_${productVersion}.tar.gz" ]; then
        if [ "${isForce}" == "1" ]; then
            tarFile="snas-collect_${productVersion}.tar.gz"
        else
            isNeedUpdateCollect "${TMP_G_SCRIPT_PATH}/snas-collect_${productVersion}.tar.gz"
            if [ $? -eq 0 ]; then
                tarFile=""
            else
                tarFile="snas-collect_${productVersion}.tar.gz"
            fi
        fi
        if [ "${tarFile}" != "" ]; then
            updFileList="${updFileList} ${tarFile}"
            filesInTar=$(tar ztf "${tarFile}" | awk '{printf " /opt/huawei/snas/bin/"$0}')
            rmtCmd="${rmtCmd};/opt/huawei/snas/script/inspect_mml/CheckItems del /opt/huawei/snas/bin/OceanStor9000_datacollect.sh;\
                              tar -zxf /var/log/snas-collect_${productVersion}.tar.gz -C /opt/huawei/snas/bin;\
                              chmod 550 ${filesInTar};chown root:group9000 ${filesInTar};\
                              chmod 500 /opt/huawei/snas/bin/OceanStor9000_datacollect.sh /opt/huawei/snas/bin/snas_log_deal.sh;\
                              chown root:root /opt/huawei/snas/bin/OceanStor9000_datacollect.sh /opt/huawei/snas/bin/snas_log_deal.sh"
        fi
    fi
    tarFile="/tmp/toolkit.app.zh.version"
    if [ -f ${tarFile} ]; then
        cp /tmp/toolkit.app.zh.version ./
        tar -czf toolkit.tar.gz toolkit.app.zh.version
        tarFile="toolkit.tar.gz"

        if [ "${isForce}" != "1" ]; then
            isNeedUpdateInspect "${TMP_G_SCRIPT_PATH}/${tarFile}"
            if [ $? -eq 0 ]; then
                tarFile=""
            fi
        fi

        if [ "${tarFile}" != "" ]; then
            updFileList="${updFileList} ${tarFile}"
            rmtCmd="${rmtCmd};tar -zxf /var/log/${tarFile} -C /opt/inspect"
        fi
    fi

    if [ -f "diagnosis.tar.gz" ]; then
        if [ "${isForce}" == "1" ]; then
            tmpUpdFileList="${tmpUpdFileList} diagnosis.tar.gz"
        else
            testDiff diagnosis.tar.gz /opt/inspect/diagnosis.tar.gz
            iRet=$?
            if [ ${iRet} -gt 1 ]; then
                tmpUpdFileList="${tmpUpdFileList} diagnosis.tar.gz"
            fi
        fi
    fi
    if [ -f "Certificate.tar.gz" ]; then
        if [ "${isForce}" == "1" ]; then
            tmpUpdFileList="${tmpUpdFileList} Certificate.tar.gz"
        else
            testDiff Certificate.tar.gz /opt/inspect/Certificate.tar.gz
            iRet=$?
            if [ ${iRet} -gt 1 ]; then
                tmpUpdFileList="${tmpUpdFileList} Certificate.tar.gz"
            fi
        fi
    fi
    if [ -f /tmp/toolkit.app.zh.version ] && [ "$(cat /tmp/toolkit.app.zh.version | grep true)" != "" ];then
        if [ -f "hotpatch_conflict_resolve.tar.gz" ]; then
            if [ "${productVersion}" == "V500R007C00SPC100" ] || [[ "${productVersion}" =~ "V300R006C20" ]];then
                if [ "${isForce}" == "1" ]; then
                    tmpUpdFileList="${tmpUpdFileList} hotpatch_conflict_resolve.tar.gz"
                else
                    testDiff hotpatch_conflict_resolve.tar.gz /opt/inspect/hotpatch_conflict_resolve.tar.gz
                    iRet=$?
                    if [ ${iRet} -gt 1 ]; then
                        tmpUpdFileList="${tmpUpdFileList} hotpatch_conflict_resolve.tar.gz"
                    fi
                fi
            fi
        fi
    fi
    updFileList=$(echo ${updFileList} | sed 's/^\s\+//;s/\s\+$//')
    if [ -n "${updFileList}" -o -n "${tmpUpdFileList}" ] && [ -f "svn_${productVersion}.txt" ]; then
        tmpUpdFileList="svn_${productVersion}.txt ${tmpUpdFileList}"
        LOG "[$FUNCNAME][$LINENO] svn_${productVersion}.tar.gz----${tmpUpdFileList} "
        tar -czf svn_${productVersion}.tar.gz ${tmpUpdFileList}
        updFileList="${updFileList} svn_${productVersion}.tar.gz"
        tar -czf pkg_inspect_${productVersion}.tar.gz ${updFileList}
        rmtCmd="${rmtCmd};tar -zxf /var/log/svn_${productVersion}.tar.gz -C /opt/inspect/"
        LOG "[$FUNCNAME][$LINENO] item:${G_CHECK_IDLIST} rmtCmd:${rmtCmd}!"
    else
        LOG "[$FUNCNAME][$LINENO] item:${G_CHECK_IDLIST} no need update!"
        return 0
    fi

    local iRet=0
    local errFlag=0
    local remoteIp=""
    local remoteIpList=$(cat $IP_ROLE_FILE )
    for remoteIp in ${remoteIpList}
    do
        /opt/huawei/deploy/script/localexec.py upload ${remoteIp} "${TMP_G_SCRIPT_PATH}/pkg_inspect_${productVersion}.tar.gz" "/var/log/pkg_inspect_${productVersion}.tar.gz"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][$LINENO] Upload file ${TMP_G_SCRIPT_PATH}/pkg_inspect_${productVersion}.tar.gz to IP:${remoteIp} failed(result:${iRet})!"
            return 1
        fi
        /opt/huawei/deploy/script/localexec.py async ${remoteIp} inspectUpdateTask 60 true "${rmtCmd}"
        iRet=$?
        if [ $iRet -ne 0 ]; then
            LOG "[$FUNCNAME][$LINENO] Replace file to IP:${remoteIp} failed(result ${iRet})!"
            return 1
        fi
    done

    for remoteIp in ${remoteIpList}; do
        while [ 1 ]; do
            remote_exec_checkfini $remoteIp inspectUpdateTask "Can not update inspect scripts."
            iRet=$?
            if [ $iRet -eq 0 ]; then
                sleep 5
                continue
            elif [ $iRet -eq 2 ]; then
                break
            else
                errFlag=1
                break
            fi
        done
    done
    return ${errFlag}
}

function clusterToolkitVer()
{
    local toolver=$1
    local svnFile=$2
    local verOnCluster=0
    if [ ! -f "${svnFile}" ]; then
        verOnCluster=0
        echo "${verOnCluster}"
        return
    fi

    local verOnNode=""
    local remoteIp=""
    local remoteIpList=$(cat $IP_ROLE_FILE)
    verOnCluster=$(grep -Po '(?<=svn=)[0-9]+' "${svnFile}")
    for remoteIp in ${remoteIpList}
    do
        verOnNode=$(/opt/huawei/deploy/script/localexec.py cmd ${remoteIp} 120 false "cat ${svnFile}")
        verOnNode=$(echo "${verOnNode}" | grep -Po '(?<=svn=)[0-9]+')
        if [ ${verOnNode:=0} -lt ${verOnCluster:=0} ]; then
            LOG "[$FUNCNAME][$LINENO] svn version on node ${remoteIp} is ${verOnNode}."
            verOnCluster=${verOnNode}
        fi
        #ҪļòѯСļȺ汾
        if [ ${toolver} -gt ${verOnCluster} ]; then
            break
        fi
    done
    echo "${verOnCluster}"
}

function ProductType2Predeal()
{
    local productVersion=""
    local deployScene=""
    declare -A equalVersion=(
        ["V100R006C10SPC400"]="V300R006C20SPC300"
        ["V100R006C10SPC460"]="V300R006C20SPC300"
        ["V100R006C10SPC500"]="V500R007C00SPC100"
        ["V100R006C10SPC600"]="V500R007C10SPC100"
        ["V100R006C10SPH601"]="V500R007C10SPC100"
        ["V100R006C10SPH602"]="V500R007C10SPC100"
        ["V100R006C10SPC800"]="V500R007C10SPC400"
        ["V100R006C10SPC900"]="V500R007C10SPC400"
        ["V100R006C30SPC500"]="V500R007C00SPC100"
        ["V100R006C30SPC505"]="V500R007C00SPC200"
        ["V100R006C30SPC510"]="V500R007C00SPC200"
        ["V100R006C30SPC700"]="V500R007C10SPC100"
        ["V100R006C30SPC900"]="V500R007C10SPC400"
    )
    if [ -f /opt/huawei/snas/etc/snas.ini ]; then
        deployScene=$(grep deployScene /opt/huawei/snas/etc/snas.ini | awk -F= '{print $2}')
    fi
    if [ "$deployScene" != "2" -a "$deployScene" != "1" ];then
        return
    fi
    [ -f /opt/huawei/deploy/package/version ] &&
        productVersion=$(grep ProductVersion /opt/huawei/deploy/package/version | awk -F= '{print $2}')
    if [ -n "${equalVersion[${productVersion}]}" ]; then
        [ -f ${TMP_G_SCRIPT_PATH}/snas-collect_${equalVersion[${productVersion}]}.tar.gz ] &&
        cp -f ${TMP_G_SCRIPT_PATH}/snas-collect_${equalVersion[${productVersion}]}.tar.gz ${TMP_G_SCRIPT_PATH}/snas-collect_${productVersion}.tar.gz
        [ -f ${TMP_G_SCRIPT_PATH}/snas-inspect_main_${equalVersion[${productVersion}]}.tar.gz ] &&
        cp -f ${TMP_G_SCRIPT_PATH}/snas-inspect_main_${equalVersion[${productVersion}]}.tar.gz ${TMP_G_SCRIPT_PATH}/snas-inspect_main_${productVersion}.tar.gz
        [ -f ${TMP_G_SCRIPT_PATH}/snas-inspect_mml_${equalVersion[${productVersion}]}.tar.gz ] &&
        cp -f ${TMP_G_SCRIPT_PATH}/snas-inspect_mml_${equalVersion[${productVersion}]}.tar.gz ${TMP_G_SCRIPT_PATH}/snas-inspect_mml_${productVersion}.tar.gz
        [ -f ${TMP_G_SCRIPT_PATH}/snas-inspect_${equalVersion[${productVersion}]}.tar.gz ] &&
        cp -f ${TMP_G_SCRIPT_PATH}/snas-inspect_${equalVersion[${productVersion}]}.tar.gz ${TMP_G_SCRIPT_PATH}/snas-inspect_${productVersion}.tar.gz
        [ -f ${TMP_G_SCRIPT_PATH}/svn_${equalVersion[${productVersion}]}.txt ] &&
        cp -f ${TMP_G_SCRIPT_PATH}/svn_${equalVersion[${productVersion}]}.txt ${TMP_G_SCRIPT_PATH}/svn_${productVersion}.txt
    fi
}

#500.Ѳ칤߰汾
CheckToolkitVersion()
{
    WRITE_XML_SUBCMD_HEADER $1
    local isPass=0
    local Result=""

    local TMP_G_SCRIPT_PATH="${TMP_G_SCRIPT_PATH}"
    local productVersion=""
    local verOnCluster=0
    local verofToolkit=0
    local forceUpdate=0
    local iRet=0
    
    if [ ! -d "${TMP_G_SCRIPT_PATH}" ];then
        LOG "[$FUNCNAME][$LINENO]failed to get the tmpinspect path"
        isPass=1
        WRITE_XML_ERROR "NODE:masternode||INFO:failed to get the temp inspect path."
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    fi
    ProductType2Predeal

    [ -f /opt/huawei/deploy/package/version ] &&
        productVersion=$(grep ProductVersion /opt/huawei/deploy/package/version | awk -F= '{print $2}')
    if [ -f  "${TMP_G_SCRIPT_PATH}/svn_${productVersion}.txt" ]; then
        verofToolkit=$(grep -Po '(?<=svn=)[0-9]+' "${TMP_G_SCRIPT_PATH}/svn_${productVersion}.txt")
    else
        verofToolkit=0
    fi
    if [ -f "/opt/inspect/svn_${productVersion}.txt" ]; then
        verOnCluster=$(clusterToolkitVer ${verofToolkit} "/opt/inspect/svn_${productVersion}.txt")
    else
        verOnCluster=0
    fi

    LOG "[$FUNCNAME][$LINENO] item:${G_CHECK_IDLIST} productver:${verOnCluster}||toolver:${verofToolkit}"

    Result="Productver:${verOnCluster}||toolver:${verofToolkit}"
    #cluster is newer than toolkit, recommand use higher toolkit version
    if [ ${verofToolkit} -lt ${verOnCluster} ]; then
        isPass=4
        WRITE_XML_COMMON 0 "$Result"
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return
    #Check inspect and data collect scripts were replaced by other tool such as patch, if changed, update
    elif [ ${verofToolkit} -eq ${verOnCluster} ]; then
        forceUpdate=0
        if [ ${verofToolkit} -eq 0 ]; then #No update package
            isPass=0
            WRITE_XML_COMMON 0 "$Result"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return
        fi
    else
        forceUpdate=1
    fi

    updateToolkit ${forceUpdate}
    iRet=$?
    if [ ${iRet} -ne 0 ]; then
        isPass=1
        LOG "[$FUNCNAME][$LINENO]item ${G_CHECK_IDLIST} failed to to update tool."
        Result="NODE:masternode||INFO:failed to update tool."
    fi
    WRITE_XML_COMMON 0 "$Result"
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
}

# **************************************************************************** #
# Function Name: checkExpandItemStatus
# Description: չѲ м.
# Parameter: $1 cmditemID
# Return:
# **************************************************************************** #
checkExpandItemStatus()
{
    local checkItem=$1


    WRITE_XML_CMD_HEADER ${checkItem}
    LOG "[${FUNCNAME[@]}][$LINENO]Enter inspect item ${checkItem}, result file $G_CHECK_RESULT_FILE"
    # ****caseеķ֧ѡ뵥****
    case ${checkItem} in
        500)
            CheckToolkitVersion "0"
            ;;
        *)
        #չѲвʱ, ع̶, ӲѲѲ
        LOG "[${FUNCNAME[@]}][$LINENO]Exit inspect item ${checkItem}"
        return 555
        ;;
    esac
    chmod 640 $LOG_FILE
    WRITE_XML_CMD_TAIL
    LOG "[${FUNCNAME[@]}][$LINENO]Exit inspect item ${checkItem}"
}

